/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

/*************  ˵  **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

ͨ"stc_usb_hid_32.lib"ļʵʹUSBӿڴӡϢڳ.

P3.2ڰʾ"printf";

P3.3ڰʾ"ShowLong";

P3.4ڰʾ"ShowFloat";

P3.5ڰʾ"ShowCode"8ֽ;

"config.h"ļѡ"PRINTF_SEGLED"壬printfݸʽضISPе7

"config.h"ļѡ"PRINTF_HID"壬printfֱضUSB HIDӿ

ʱ, ѡʱ 24MHz ("config.h"ļ޸).

******************************************/

#include "config.h"
#include "../comm/stc32g.h"
#include "../comm/stc32_stc8_usb.h"
#include <stdio.h>

void sys_init();

//USBԼλ趨
char *USER_DEVICEDESC = NULL;
char *USER_PRODUCTDESC = NULL;
char *USER_STCISPCMD = "@STCISP#";                      //ԶλISPûӿ

BYTE xdata cod[8];

void main()
{
    sys_init();
    usb_init();  //USBʼ
    EA = 1;
    
    while (1)
    {
        if (bUsbOutReady)
        {
//            USB_SendData(UsbOutBuffer,64);  //ݻȣԭ, ڲԣ
            
            usb_OUT_done(); //Ӧ𣨹̶ʽ
        }
        
        if (!P32)
        {
            while (!P32);
            printf("%08lx", 0x1234abcdL);  //ʹprintfضUSB
        }
        else if (!P33)
        {
            while (!P33);
            SEG7_ShowLong(0x98765432, 16);  //ܳ
        }
        else if (!P34)
        {
            while (!P34);
            SEG7_ShowFloat(3.1415);  //ܸ
        }
        else if (!P35)
        {
            cod[0] = 0x3f;  //ܶ
            cod[1] = 0x06;
            cod[2] = 0x5b;
            cod[3] = 0x4f;
            cod[4] = 0x66;
            cod[5] = 0x6d;
            cod[6] = 0x7d;
            cod[7] = 0x27;
            while (!P35);
            SEG7_ShowCode(cod);  //ֵ
        }
    }
}

void sys_init()
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x32;   P1M0 = 0x32;   //P1.1P1.4P1.5Ϊ©·(ʵ赽3.3V), P1.1PWMDAC·ͨ贮P2.3
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)ÿ©ģʽҪϿPWMDAC·еR2
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫
}

